﻿Imports System.Runtime.InteropServices

Public Delegate Function CallBack(ByVal nCode As Integer, ByVal wParam As IntPtr, ByVal lParam As IntPtr) As Integer

Public Class Form1

    Const WH_MOUSE As Integer = 7
    Shared hHook As Integer = 0
    Private hookproc As CallBack
    <DllImport("kernel32.dll")> _
    Public Shared Function GetCurrentThreadId() As Integer
    End Function
    'Import for the SetWindowsHookEx function.
    <DllImport("User32.dll", CharSet:=CharSet.Auto, CallingConvention:=CallingConvention.StdCall)> _
    Public Overloads Shared Function SetWindowsHookEx _
          (ByVal idHook As Integer, ByVal HookProc As CallBack, _
           ByVal hInstance As IntPtr, ByVal wParam As Integer) As Integer
    End Function

    'Import for the CallNextHookEx function.
    <DllImport("User32.dll", CharSet:=CharSet.Auto, CallingConvention:=CallingConvention.StdCall)> _
    Public Overloads Shared Function CallNextHookEx _
          (ByVal idHook As Integer, ByVal nCode As Integer, _
           ByVal wParam As IntPtr, ByVal lParam As IntPtr) As Integer
    End Function
    'Import for the UnhookWindowsHookEx function.
    <DllImport("User32.dll", CharSet:=CharSet.Auto, CallingConvention:=CallingConvention.StdCall)> _
    Public Overloads Shared Function UnhookWindowsHookEx _
              (ByVal idHook As Integer) As Boolean
    End Function

    'Point structure declaration.
    <StructLayout(LayoutKind.Sequential)> Public Structure Point
        Public x As Integer
        Public y As Integer
    End Structure

    'MouseHookStruct structure declaration.
    <StructLayout(LayoutKind.Sequential)> Public Structure MouseHookStruct
        Public pt As Point
        Public hwnd As Integer
        Public wHitTestCode As Integer
        Public dwExtraInfo As Integer
    End Structure

    Private Sub Form1_Disposed(sender As Object, e As System.EventArgs) Handles Me.Disposed
        If Not hHook.Equals(0) Then
            'unhook mouse
            Dim ret As Boolean = UnhookWindowsHookEx(hHook)

            If ret.Equals(False) Then
                MsgBox("UnhookWindowsHookEx Failed")
                Return
            End If
        End If
    End Sub

    Private Sub Form1_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        'The AxAcroPDF control takes focus when a PDF file is loaded into it.
        'To prevent this, the AxAcroPDF control is placed into a panel which is 
        'disabled prior to loading a pdf. This intern disables the AxAcroPDF control
        'preventing it from taking focus.

        'A mouse hook is used to check if the mouse has entered the area of the panel,
        'in which case the panel is enabled to allow the user to interact with the
        'AxAcroPDF control



        'add sample items to listbox
        ListBox1.Items.Add("PDF 1")
        ListBox1.Items.Add("PDF 2")
        ListBox1.Items.Add("PDF 3")
    End Sub

    Private Sub ListBox1_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles ListBox1.SelectedIndexChanged
        'load pdf file based on listbox selected index

        'build pdf file name
        Dim pdffile As String = Application.StartupPath & "\pdf" & ListBox1.SelectedIndex + 1 & ".pdf"

        'make sure file exists
        If System.IO.File.Exists(pdffile) = False Then MsgBox("File not found") : Exit Sub

        'Disable the panel to prevent the acrobat control from taking focus
        'Only do so if we are currently hooking the mouse
        If Not hHook.Equals(0) Then Panel1.Enabled = False

        'load the file
        AxAcroPDF1.src = pdffile


    End Sub

    Public Shared Function MouseHookProc(ByVal nCode As Integer, ByVal wParam As IntPtr, ByVal lParam As IntPtr) As Integer
        Dim MyMouseHookStruct As New MouseHookStruct()


        If (nCode < 0) Then
            Return CallNextHookEx(hHook, nCode, wParam, lParam)
        End If

        MyMouseHookStruct = CType(Marshal.PtrToStructure(lParam, MyMouseHookStruct.GetType()), MouseHookStruct)


        Dim pt As System.Drawing.Point
        pt.X = MyMouseHookStruct.pt.x
        pt.Y = MyMouseHookStruct.pt.y


        If Form1.Panel1.RectangleToScreen(Form1.Panel1.ClientRectangle).Contains(pt) Then
            'mouse over the panel containing the acrobat control.  Enable it
            Form1.Panel1.Enabled = True
        End If

       
        Return CallNextHookEx(hHook, nCode, wParam, lParam)

    End Function

    Private Sub Button1_Click(sender As System.Object, e As System.EventArgs) Handles Button1.Click
        'Hook the mouse

        If hHook.Equals(0) Then
            hookproc = AddressOf MouseHookProc
            hHook = SetWindowsHookEx(WH_MOUSE, hookproc, IntPtr.Zero, GetCurrentThreadId())
            If hHook.Equals(0) Then
                MsgBox("SetWindowsHookEx failed")
                Return
            Else
                Button1.Text = "UnHook Mouse"
            End If
        Else
            Panel1.Enabled = True
            Dim ret As Boolean = UnhookWindowsHookEx(hHook)

            If ret.Equals(False) Then
                MsgBox("UnhookWindowsHookEx Failed")
                Return
            Else
                hHook = 0
                Button1.Text = "Hook Mouse"

            End If
        End If
    End Sub
End Class
